/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
void InitPre()
{
   App.name="Waypoints";
   App.flag=APP_FULL_TOGGLE|APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).ambPower(0.3);

   ViewportFull.range=50;
   Cam.at.set(16,0,16);
   Cam.dist = 20;
   Cam.pitch=-PI_3;
}
/******************************************************************************/
Bool Init()
{
   Text_ds.scale*=0.8;

   Physics.create();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();
   Sky    .set   ();

   Game::World.init(                 )
              .New ("world/waypoints");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Game::World.update(Cam.at);

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void DrawWaypoints(Char *name)
{
   if(Game::Waypoint *waypoint=Game::World.findWaypoint(name)) // if waypoint exists
   {
              waypoint->draw(           ); // draw waypoint
      Vec pos=waypoint->pos (Tm.time()*2); // access waypoints position at 'Tm.time()*2' length
          pos.draw(RED);                   // draw the position as red dot
   }
}
void Draw()
{
   Renderer(Render);

   // draw waypoints
   // 3 waypoints are stored in World used in this tutorial, they're named as follow: "0", "1", "2"
   MatrixSet(); // first reset matrix
   REP(3)DrawWaypoints(S+i); // draw each waypoint

   D.text(0,0.9,"Notice that different Waypoints have different looping modes");
   D.text(0,0.8,"Waypoints with their looping modes are set in World Editor");
}
/******************************************************************************/
